#!/bin/bash
#SBATCH --mem=8G
#SBATCH --cpus-per-task=5
#SBATCH --time=5:00:00              # Time limit hrs:min:sec
#SBATCH --output=/scratch/shared/beegfs/yuki/slurm/IN21k/pass-%a.out    # Standard output and error log
#SBATCH --open-mode=A
#SBATCH --partition=compute
#SBATCH --constraint=10GbE
#SBATCH --job-name=IN21k-pass
#SBATCH --array=0-50

cd /users/yuki/adiwol/experts/IN21k

echo $SLURM_ARRAY_TASK_ID
X=$((${SLURM_ARRAY_TASK_ID}*26000))
Y=$(((${SLURM_ARRAY_TASK_ID} + 1)*26000))

in_file=_split_pass_${SLURM_ARRAY_TASK_ID}.txt
rm ${in_file}
results_dir='/scratch/shared/beegfs/yuki/data/fast/split_PASS/IN21k-r503x/'
mkdir -p ${results_dir}

< /scratch/shared/beegfs/yuki/data/split_user_stratified.txt tail -n +"$X" | head -n "$((Y - X))" >> ${in_file}

/scratch/shared/beegfs/yuki/envs/py37/bin/python main_in21k.py \
                                                  --input_txt=${in_file} \
                                                  --save_folder=${results_dir} \
                                                  --split $SLURM_ARRAY_TASK_ID \
                                                  --cpu

